/**************************************************************************
* 
*  PROGRAM   Using S08QE128, the program will run uC in FEE Mode
*  
*  AUTHOR    Steven McLaughlin, Applications Engineer, East Kilbride, Scotland
*
*  DATE      August 2007
*
*  NOTES     
*
****************************************************************************/ 

/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2006 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       ICS_demo.c               											
*														              					
* Description:	     	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		

/* include files */
#include "MC9S08QE128.H" /* include peripheral declarations */ 

/*****************************************************************************
*
*
*  FUNCTION    main
*
*  DESCRIPTION  - main routine
*               - sets up the ICS in FEE Mode 
*
*  RETURNS     None
*
*  NOTES:     Fext = 32.768kHz (ext crystal)
*
******************************************************************************/
void main(void) {

     /*Disable COP*/
     SOPT1_COPT=0b00;
                  

/***********Set up the clock registers to enter FEE mode *********************/
    
    //////////////ICS Control Register 2 (ICSC2)//////////////////////////////
    //
    //      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
    //    --------- --------- --------- --------- --------- ---------- --------- ---------
    //    |       BDIV        | RANGE   |   HGO   |   LP    |   EREFS  | ERCLKEN | EREFSTEN|
    //     ------------------- --------- --------- --------- ---------- --------- ---------
    //    |   0         0     |    0    |    0    |    0    |     1    |    1    |    0    |
    //     ------------------- --------- --------- --------- ---------- --------- --------
    //
    //
    //    BDIV     = 00    Set clock to divide by 1 
    //    RANGE    = 0     Low Freq range selected (i.e. 32.768 kHz in high freq range)                      
    //    HGO      = 0     Ext Osc configured for low gain                
    //    LP       = 0     FLL is not disabled in bypass modes
    //    EREFS    = 1     Osc requested
    //    ERCLKEN  = 1     ICSERCLK active 
    //    EREFSTEN = 0     Ext Reference clock is disabled in stop
    // 
    ///////////////////////////////////////////////////////////////////////////
    ICSC2=0b00000110;
    
    /* Loop until OSCINIT = 1 - indicates crystal selected by EREFS bit has been initalised*/
    while(ICSSC_OSCINIT!=1);
    
    
    /////////////////////ICS Control Register 1 (ICSC1)///////////////////////////////////////
    //
    //      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
    //     --------- --------- --------- --------- --------- ---------- --------- ---------
    //    |       CLKS        |            RDIV             |  IREFS   |IRCLKEN  |IREFSTEN |
    //     ------------------- --------- --------- --------- ---------- --------- ---------
    //    |   0         0     |    0    |    0    |    0    |     0    |    0    |    0    |
    //     ------------------- --------- --------- --------- ---------- --------- --------
    //
    //
    //    CLKS     = 00    Select clk source via FLL
    //    RDIV     = 000   Set to divide by 1 (i.e. 31.768kHz/1 = 31.768kHz - in range required by FLL)                      
    //    IREFS    = 0     Ext Ref clock selected
    //    IRCLKEN  = 0     ICSIRCLK inactive
    //    IREFSTEN = 0     Internal ref clock disabled in stop               
    // 
    //////////////////////////////////////////////////////////////////////////////////////////
    
 
     ICSC1=0b00000000;
     
    
        /*loop until IREFST = 0 - indicates ext ref is current source*/
    while(ICSSC_IREFST!=0);
    
    
    /*loop until CLKST = 00 - indiates ext ref clk selected to feed ICSOUT*/
    while(ICSSC_CLKST!=0b00);
    
  
    ICSSC_DRST_DRS = 0b00;       /*set DCO factor at 512*/ 
  
     
     PTED_PTED0 = 0;     /* Set port as o/p*/
     PTEDD = 0x01;       
  
  
  for(;;) {
  
      PTED_PTED0 ^=1;       /* Toggle PTE0 */
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}